#version 330
#extension GL_EXT_gpu_shader4 : enable
//NewtonFractal on sphereMod01.fsh  by   elle

//https://www.shadertoy.com/view/WdBcRV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec4 sphere = vec4(0.0, 0.0, 1.0, 0.4);
vec3 lightPos = vec3(-9.0, 8.0, -8.0);
vec3 lightCol = vec3(1.0, 1.0, 1.0);

float sphereDist1(vec3 ro, vec3 rd)
{
	float R = sphere.w;
	vec3 d1 = sphere.xyz - ro;
	float b = dot(rd, d1);
	float d2 = dot(d1, d1) - b * b;
	float h2 = R * R - d2;
    if (h2 <= 0.0)
        return (-1.0);
    return (b - sqrt(h2));
}

float sphereDist(vec3 p)
{
 return (length(p - sphere.xyz) - sphere.w);   
}

vec3 hsv2rgb(vec3 c)
{
    vec3 rgb = clamp(abs(mod(c.x * 6.0 + vec3(0.0,4.0,2.0),6.0) - 3.0) - 1.0, 0.0, 1.0);
	return (c.z * mix(vec3(1.0), rgb, c.y));
}

// https://iquilezles.org/articles/rmshadows
float getShadow(vec3 ro, vec3 rd, float tmin, float tmax, const float k)
{
	float res = 1.0;
    float t = tmin;
    for( int i = 0; i < 50; i++)
    {
		float h = sphereDist(ro + rd * t);
        res = min(res, k * h / t);
        t += clamp(h, 0.02, 0.20);
        if(res < 0.005 || t > tmax)
            break;
    }
    return clamp(res, 0.0, 1.0);
}

// https://iquilezles.org/articles/normalsSDF
vec3 getNormal(vec3 pos)
{
    const float ep = 0.0001;
    vec2 e = vec2(1.0, -1.0) * 0.5773;
    return normalize( e.xyy*sphereDist(pos + e.xyy*ep) + 
					  e.yyx*sphereDist(pos + e.yyx*ep) + 
					  e.yxy*sphereDist(pos + e.yxy*ep) + 
					  e.xxx*sphereDist(pos + e.xxx*ep));
}


vec2 f(vec2 z)
{
    float mag = dot(z, z);
    return (2.0 * z + vec2(z.x * z.x - z.y * z.y, -2.0 * z.x * z.y) / (mag * mag)) / 3.0;
}

vec2 roots[] = vec2[](vec2(1.0, 0.0), vec2(-0.5, 0.5 * sqrt(3.0)), vec2(-0.5, -0.5 * sqrt(3.0)));

float newton(vec2 z) 
{
    vec4 res;
    for (int i = 0; i < 100; ++i)
    {
    	z = f(z); 
        for (int root = 0; root < roots.length(); ++root)
        {
            vec2 differ = z - roots[root];
            float dist = dot(differ, differ);
            if (dist < 0.00001)
				return (0.78 * cos(1.5 * log2(log(dist) / log(0.0001))));
        }
    }
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
   vec2 aspectRatio = vec2(iResolution.x / iResolution.y, 1.0);
    vec2 uv = aspectRatio * (gl_FragCoord.xy / iResolution.xy - 0.5);
    vec2 mouse = 7.0 * (iMouse.xy / iResolution.xy - 0.5);  
    vec3 ro = vec3(0.0, 0.0, 0.0);
    vec3 rd = normalize(vec3(uv, 1.0));
    mouse.y += 0.3;
	float rot = -0.2;//iTime * 0.2;
    mat3 rotX = mat3(
        vec3(cos(mouse.x - rot), 0.0, sin(mouse.x - rot)),
        vec3(0.0, 1.0, 0.0),
        vec3(-sin(mouse.x - rot), 0.0, cos(mouse.x - rot)));  
	mat3 rotY = mat3(
        vec3(1.0, 0.0, 0.0),
        vec3(0.0, cos(mouse.y), sin(mouse.y)),
        vec3(0.0, -sin(mouse.y), cos(mouse.y)));
	
    float dSphere = sphereDist1(ro, rd);
	vec3 pos = ro + dSphere * rd;
	vec3 normal = getNormal(pos);
	vec3 v3 = rotX * rotY * normal;
    vec2 v2 = 9.0 * (cos(iTime * 0.2)) * v3.xy / abs(v3.z);
    vec3 material;
    if (dSphere < 0.0)
        material = hsv2rgb(vec3(newton(v2), 0.8, 0.5));
    else
        material = hsv2rgb(vec3(newton(v2), 1.0, 1.2));
    vec3 lightDir = normalize(vec3(lightPos - pos));
    vec3 reflectDir = normalize(reflect(lightDir, normal));
    float shadow = getShadow(pos, lightDir, 0.001, 1.0, 32.0);
        
    float diffuse = clamp(dot(normal, lightDir), 0.0, 1.0) * shadow * 0.4;
    float ambient = 0.4 + 0.55 * normal.y;
	float specular = pow(clamp(dot(reflectDir, rd), 0.0, 1.0), 32.0) * 1.2 * shadow;
        
	vec3 color = lightCol * material * (diffuse + specular + ambient);
    color = sqrt(color);
    color = pow(color, lightCol);
    gl_FragColor = vec4(color, 1.0); 
}